![Logo](https://github.com/dvdh1961/ADAMP/blob/main/scrcpp/ADAMP.png)

This software is free to use for personal, educational, and non-profit purposes under the PolyForm Noncommercial License 1.0.0.

"Certain portions of the software are subject to third-party copyright, prohibiting the commercial use of this compilation. 
 All C++ code is 100% authored by me and is permitted for use for all purposes."

A ColecoVision and ADAM Emulator & Debugging Suite for Windows & Linux.

ADAM+ is a modern emulator and development toolkit for the ColecoVision and Coleco ADAM systems, built with Qt6 and inspired by the original EmulTwo project.
The software has been completely redesigned from the ground up, focusing on stability, performance, and expandability.

It serves as a central platform for integrating a wide range of hardware-related devices, all developed as part of the broader ADAM+ hardware project.

![Logo](https://github.com/dvdh1961/ADAMP/blob/main/scrcpp/ADAMP_EMU_HARDWARE_SNAP.png)
![Logo](https://github.com/dvdh1961/ADAMP/blob/main/scrcpp/ADAMP_EMU_HARDWARE_SNAP2.png)

## 💾 Downloads

[![release](https://img.shields.io/badge/Latest%20release-windows32-green.svg)](https://github.com/dvdh1961/ADAMP/releases/download/0.2.11.25/Setup_ADAMP_EMU_0.2.1125.exe)
[![release](https://img.shields.io/badge/Latest%20release-linux32-blue.svg)](https://github.com/dvdh1961/ADAMP/releases/download/0.2.11.25/ADAMP_EMU.AppImage)
![Current Release](https://img.shields.io/badge/Version-V0.2.1125-yellow)
![Total Downloads](https://img.shields.io/github/downloads/dvdh1961/ADAMP/total.svg)
[![YouTube](https://img.shields.io/badge/YouTube-FF0000?logo=youtube&logoColor=white)](https://youtu.be/vobLE2F9Cc0)
[![License: GPL-2.0](https://img.shields.io/badge/License-PolyForm%20Noncommercial%20License%201.0.0-blue.svg)](https://polyformproject.org/licenses/noncommercial/1.0.0/)

![Commits](https://img.shields.io/github/commits-since/dvdh1961/ADAMP/latest)
[![Contributors](https://img.shields.io/github/contributors/dvdh1961/ADAMP)](https://github.com/dvdh1961/ADAMP/graphs/contributors)
![Stars](https://img.shields.io/github/stars/dvdh1961/ADAMP)
![Issues](https://img.shields.io/github/issues/dvdh1961/ADAMP)
[![GitHub Sponsors](https://img.shields.io/github/sponsors/dvdh1961)](https://github.com/sponsors/dvdh1961)
[![Donate](https://img.shields.io/badge/Donate-PayPal-blue.svg)](https://www.paypal.com/donate?business=dannyvdh@pandora.be)

## 🚀 Features

Version 0.3.11.15 (Soon available)
- LICENSE changed to PolyForm Noncommercial License 1.0.0 (because some software issues with licensing rules)
- Added USB joystick support
- Added resizing application to any format
- Added switch bezels on/off
- Added snap windows on/off
- Added saving geometry
- Changed installation path (windows --> no program files anymore)
- Media map now standard configured into working directory (No save issues anymore)

Version 0.2.11.25
- LINUX VERSION x86-64 added
- Added 4 tapes / 4 disks support
- Added printer clipboard and removed some bugs with PR#1
- Updated logging

Version 0.1.10.25
- 🎮 **ColecoVision** game support (`.rom`, `.bin`, `.col`)
- 🪛 **Built-in Debugging Tools**
  - Tile, Sprite, VRAM, RAM, and Disassembly viewers  
  - Perfect for tracking bugs in homebrew or development builds
- 🔊 **Super Game Module** support (inclusief AY-soundchip)
- 🧠 **Megacart Bankswitching** up to 512 KB
- 🎯 **Full Controller Button Mapping**
- 💾 **Coleco ADAM** game support (`.ddp`, `.dsk`)
- 🖨️ **Print to txt and pdf support (with smartwritter some issues)
- 🎨 **Pixel sharp,smooth and EPX interpolation
- 🖥️ **Full screen option with buildin bezels 
- ✒️ **LOAD & SAVE on your media!
- 💾 **Save / Load Game State**

## 💡Info
- You need the free community QT Creator to build the project.

## 🚧 ToDo

- 🕹️ Hardware integration with ADAM+ console (connecting Hardware, Cartridges,Keyboard,Joypads,...)

## ADAM+ The Emulated Computer Entertainment System

## Lots of tools to examine and learn
![Logo](https://github.com/dvdh1961/ADAMP/blob/main/scrcpp/AdamPpic1.png)
![Logo](https://github.com/dvdh1961/ADAMP/blob/main/scrcpp/AdamPpic2.png)
## Smartbasic list to Clipboard
![Logo](https://github.com/dvdh1961/ADAMP/blob/main/scrcpp/ADAMP_PRINTER.gif)
## Debugger breakpoint
![Logo](https://github.com/dvdh1961/ADAMP/blob/main/scrcpp/ADAMP_DEBUG.gif)

## Credits

Thanks to everyone who shared their knowledge and inspiration — without them, this project would never have come to life.
- E.mul T.wo           (https://github.com/alekmaul/emultwo)
- Marat Fayzullin      (https://fms.komkon.org/ColEm/)
- wavemotion-dave      (https://github.com/wavemotion-dave/ColecoDS)
- Fuse                 (https://fuse-emulator.sourceforge.net/)
- EightyOne            (https://sourceforge.net/projects/eightyone-sinclair-emulator/)
- Russell Marks        (https://sz81.sourceforge.net/)
- Juergen Buchmueller  (z80 code)

## Support ADAM+

ADAM+ is free but you can donate to support its development

[![PayPal](https://img.shields.io/badge/Donate-PayPal-blue.svg)](https://www.paypal.com/donate?business=dannyvdh@pandora.be)

## License

ADAM+ software is free to use for personal, educational, and non-profit purposes under the PolyForm Noncommercial License 1.0.0.
